<?php

namespace controller;

use ControllerScheme;
use model\PaymentTable;

class Events extends ControllerScheme {
	const name = 'رویداد';

	public static $__uploads = ["event_cover" => __SOURCE__ . "images/Events/"];

	public function cardPayments() {
		$payments = PaymentTable::Db()->where('payment_type', 'event_registration_card')->where('payment_status', 'is', null)->get();
		return $this->view($this->viewName(), 'cardPayments', [
			$payments
		]);
	}

	public function cryptoPayments() {
		$payments = PaymentTable::Db()->where('payment_type', 'event_registration_crypto')->where('payment_status', 'is', null)->get();
		return $this->view($this->viewName(), 'cryptoPayments', [
			$payments
		]);
	}

	public
	function deletePayment() {
		if (PaymentTable::delete($this->requestArray('paymentId'))) {
			return "1";
		}
		return "0";
	}
}