<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\ReportScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\PaymentTable;

class UserMembershipReports extends ReportScheme {
    public function getReport() {
        ob_start();
        $user_id = $this->isSet('user_id', function ($user_id) {
            if (is_numeric($user_id) and $user_id > 0) {
                return $user_id;
            }
            return null;
        });
        $db = \model\PaymentTable::Db()->where('payment_id', '>', '0')->where('payment_type', '=', 'buyPlan')->where('payment_status', '=', 1);
        $addCards = '';
        if ($user_id) {
            $db->where('user_id', '=', $user_id);

            $user = \model\Users::get($user_id);
            $currentMembership = $user->membership_id!=0?\model\Memberships::get($user->membership_id)->membership_name:'بدون اشتراک';
            $membershipActivatedAt = $user->membership_activated_at?jdate("Y/m/d",$user->membership_activated_at):'-';
            $membershipExpiredAt = $user->membership_expired_at?jdate("Y/m/d",$user->membership_expired_at):'-';
            $addCards = $this->addCard($currentMembership, 'اشتراک فعلی','success').
            $this->addCard($membershipActivatedAt, 'تاریخ خرید','success').
            $this->addCard($membershipExpiredAt, 'تاریخ انقضا','success');
        }
        $res = $db->get()->values()->all();
        $rows = [];
        $DeliveryReportView = new \view\UserMembershipReports($this);
        $i = 0;
        foreach ($res as $order) {
            $rows[] = $DeliveryReportView->toRow($order, $i);
            $res[] = $order;
        }



        $html = HtmlTags::Div('.card-body')->Attrs(['style' => 'overflow-x: scroll'])->Content(

            $addCards,

            HtmlTags::Table('.table.table-bordered')->Content(
                HtmlTags::Thead('.table-dark')->Content(
                    $DeliveryReportView->thList()
                ),
                HtmlTags::Tbody()->Content(
                    implode('', $rows)
                )
            )
        );
        if (sizeof($res) === 0) {
            $html = HtmlTags::Div('.text-center.m-5')->Content(
                "نتیجه ای یافت نشد"
            );
        }
        echo json_encode([
            'status' => true,
            'html'   => $html
        ]);
    }

    private function addCard(string $showNumber, string $nameFiled, string $color = "success", string $link = "", string $id = ""): \FwHtml\Elements\Tags\Div {
        return HtmlTags::Div('.col-md-4.d-inline-block')->Content(
            HtmlTags::Div(".small-box.card.card-$color.card-outline")->Content(
                HtmlTags::Div('.inner.text-center')->Content(
                    HtmlTags::H3($showNumber),
                    HtmlTags::P($nameFiled)
                )
            )
        );
    }


    protected function setModel(Model $model = null): void {
        $this->model = new \model\PaymentTable();
        $this->setKey($this->model->_key);
    }


}
