import Module from './Module';
import { OutputOptions } from './rollup/index';
import Graph from './Graph';
import ExternalModule from './ExternalModule';
export default class Bundle {
    graph: Graph;
    orderedModules: Module[];
    externalModules: ExternalModule[];
    entryModule: Module;
    constructor(graph: Graph, orderedModules: Module[]);
    bind(): void;
    includeMarked(treeshake: boolean): void;
    setFascade(entryModule: Module): void;
    processExternals(): void;
    collectAddon(initialAddon: string, addonName: 'banner' | 'footer' | 'intro' | 'outro', sep?: string): Promise<string>;
    getPathRelativeToEntryDirname(resolvedId: string): string;
    deconflict(): void;
    private setRenderResolutions(options);
    render(options: OutputOptions): Promise<{
        code: string;
        map: any;
    }>;
}
