import { ObjectPath, ObjectPathKey } from '../variables/VariableReassignmentTracker';
import Property from './Property';
import CallOptions from '../CallOptions';
import ExecutionPathOptions from '../ExecutionPathOptions';
import { ExpressionEntity, ForEachReturnExpressionCallback, SomeReturnExpressionCallback } from './shared/Expression';
import { NodeBase } from './shared/Node';
import { NodeType } from './index';
export declare const UNKNOWN_OBJECT_EXPRESSION: ExpressionEntity;
export default class ObjectExpression extends NodeBase {
    type: NodeType.ObjectExpression;
    properties: Property[];
    reassignPath(path: ObjectPath, options: ExecutionPathOptions): void;
    forEachReturnExpressionWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, callback: ForEachReturnExpressionCallback, options: ExecutionPathOptions): void;
    _getPossiblePropertiesWithName(name: ObjectPathKey, kinds: ObjectPath): {
        properties: Property[];
        hasCertainHit: boolean;
    };
    hasEffectsWhenAccessedAtPath(path: ObjectPath, options: ExecutionPathOptions): boolean;
    hasEffectsWhenAssignedAtPath(path: ObjectPath, options: ExecutionPathOptions): boolean;
    hasEffectsWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, options: ExecutionPathOptions): boolean;
    someReturnExpressionWhenCalledAtPath(path: ObjectPath, callOptions: CallOptions, predicateFunction: SomeReturnExpressionCallback, options: ExecutionPathOptions): boolean;
}
