<?php

namespace version;
if (!class_exists('\version\ApiVersions')) {
	class  ApiVersions {
		const one = 'v1';
		const two = 'v2';
		private string $currentVersion;
		private array $classes;

		public function __construct(string $currentVersion, array $classes) {

			$this->currentVersion = $currentVersion;
			$this->classes = $classes;
		}

		public static function version(string $version, array $classes): \version\ApiVersions {
			return new \version\ApiVersions($version, $classes);
		}

		/**
		 * @return array
		 */
		public function getClasses(): array {
			return $this->classes;
		}

		/**
		 * @param array $classes
		 */
		public function setClasses(array $classes): void {
			$this->classes = $classes;
		}

		/**
		 * @return string
		 */
		public function getCurrentVersion(): string {
			return $this->currentVersion;
		}

		/**
		 * @param string $currentVersion
		 */
		public function setCurrentVersion(string $currentVersion): void {
			$this->currentVersion = $currentVersion;
		}
	}
}
