<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class ArtistsEntity extends EntityScheme {
	public $artist_id;
	public $artist_name;
	public $artist_image;
	public $artist_job;
	public $artist_bio;
	public $artist_share;
	public $artist_alive;
	public $artist_activity;
	public $artist_social_media;

	public function model() {
		return new \model\Artists();
	}

	public function toOption(): Option {
		return HtmlTags::Option()->Value($this->artist_id)->Content($this->artist_name);
	}

	public function apiFormat(): array {
        $books =  \model\Books::Db()->where('artist_id' , $this->artist_id)->rowCount();
        $stories = \model\Stories::Db()->where('artist_id' , $this->artist_id)->rowCount();
        $audioBooks = \model\AudioBooks::Db()->where('artist_id' , $this->artist_id)->rowCount();
		return [
			'id'             => $this->artist_id,
			'name'           => $this->artist_name,
			'image'          => __IMAGES__ . 'Artists/' . $this->artist_image,
			'followersCount' => 0,
			'totalContent' => $books + $stories + $audioBooks,
		];
	}

	protected function dictionary(): array {
		return [
			'artist_id'           => 'artist_id',
			'artist_name'         => 'artist_name',
			'artist_image'        => 'artist_image',
			'artist_job'          => 'artist_job',
			'artist_bio'          => 'artist_bio',
			'artist_share'        => 'artist_share',
			'artist_alive'        => 'artist_alive',
			'artist_activity'     => 'artist_activity',
			'artist_social_media' => 'artist_social_media',
		];
	}
}
