<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Bookmarks;
use model\Comments;
use model\Likes;
use model\Views;

class AudioBookEpisodesEntity extends EntityScheme {
	public $audio_book_episode_id;
	/**
	 * انتخاب کتاب صوتی
	 **/
	public $book_id;
	/**
	 * قسمت
	 **/
	public $episode_number;
	/**
	 * محتوای قسمت
	 **/
	public $episode_content;
	/**
	 * تاریخ
	 **/
	public $episode_date;

	public function model(): \model\AudioBookEpisodes {
		return new \model\AudioBookEpisodes();
	}

	public function apiFormat(bool $hasAccess = false, $userId = 0): array {
		$isBookmarked = Bookmarks::Db()->where([
				'audio_book_id' => $this->book_id,
				'episode_id'    => $this->audio_book_episode_id,
				'user_id'       => $userId,
			])->rowCount() > 0;
		$isLiked = Likes::Db()->where([
				'audio_book_id' => $this->book_id,
				'episode_id'    => $this->audio_book_episode_id,
				'user_id'       => $userId = 0,
			])->rowCount() > 0;

		$likes = Likes::Db()->where([
			'audio_book_id' => $this->book_id,
			'episode_id'    => $this->audio_book_episode_id,
		])->rowCount();
		$comments = Comments::Db()->where([
			'audio_book_id' => $this->book_id,
			'episode_id'    => $this->audio_book_episode_id,
		])->rowCount();
		$views = Views::Db()->where([
			'audio_book_id' => $this->book_id,
			'content_id'    => $this->audio_book_episode_id,
		])->rowCount();
		$isFree = (int)$this->episode_number <= 3;

		return [
			'id'           => (int)$this->audio_book_episode_id,
			'number'       => (int)$this->episode_number,
			'content'      => __IMAGES__ . "AudioBookEpisodes/" . $this->episode_content,
			'date'         => (int)$this->episode_date,
			'isBookmarked' => $isBookmarked,
			'isLiked'      => $isLiked,
			'isFree'       => $isFree,
			'isLocked'     => !$isFree && !$hasAccess,
			'likes'        => $likes,
			'comments'     => $comments,
			'views'        => $views,
		];
	}

	protected function dictionary(): array {
		return [
			'audio_book_episode_id' => 'audio_book_episode_id',
			'book_id'               => 'audio_book_id',
			'episode_number'        => 'episode_number',
			'episode_content'       => 'episode_content',
			'episode_date'          => 'episode_date',
		];
	}
}
