<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\AudioBookEpisodes;
use model\Episodes;
use model\Memberships;

class BookmarksEntity extends EntityScheme {
	public $bookmark_id;
	/**
	 * انتخاب کاربر
	 **/
	public $user_id;
	/**
	 * انتخاب کتاب
	 **/
	public $book_id;
	/**
	 * انتخاب داستان
	 **/
	public $story_id;
	public $audio_book_id;

	public function model() {
		return new \model\Bookmarks();
	}

	public function apiFormat(?UsersEntity $user = null): array {
		$book = \model\Books::get($this->book_id);
		$story = \model\Stories::get($this->story_id);
		$audioBook = \model\AudioBooks::get($this->audio_book_id);
		$ep = null;
		$hasAccess = false;
		if ($user instanceof UsersEntity) {
			$plan = Memberships::get($user->membership_id);
			$hasAccess = !(($plan instanceof MembershipsEntity and $user->membership_expired_at > 0 and $user->membership_activated_at > 0 and $user->membership_expired_at <= time()) or $plan == null);
		}
		if ($story instanceof StoriesEntity) {

			$episode = Episodes::get($this->episode_id);
			if ($episode instanceof EpisodesEntity) {
				$ep = $episode->apiFormat($hasAccess, $user->user_id);
			}
		}
		if ($audioBook instanceof AudioBooksEntity) {
			$episode = AudioBookEpisodes::get($this->episode_id);
			if ($episode instanceof AudioBookEpisodesEntity) {
				$ep = $episode->apiFormat($hasAccess, $user->user_id);
			}
		}
		return [
			'id'        => $this->bookmark_id,
			'book'      => $book instanceof BooksEntity ? $book->apiFormat(true) : null,
			'story'     => $story instanceof StoriesEntity ? $story->apiFormat(null, true) : null,
			'audioBook' => $audioBook instanceof AudioBooksEntity ? $audioBook->apiFormat(null, true) : null,
			'episode'   => $ep,
		];
	}

	protected function dictionary(): array {
		return [
			'bookmark_id'   => 'bookmark_id',
			'user_id'       => 'user_id',
			'book_id'       => 'book_id',
			'story_id'      => 'story_id',
			'audio_book_id' => 'audio_book_id',
		];
	}
}
