<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Plans;

class DiscountsEntity extends EntityScheme {
	public $discount_id;
	/**
	 * نوع تخفیف
	 **/
	public $type;
	/**
	 * تعداد استفاده هر کاربر
	 **/
	public $use;
	/**
	 * تعداد کدتخفیف
	 **/
	public $number;
	/**
	 * تاریخ انقضا کد
	 **/
	public $expire_date;
	/**
	 * استفاده کد برای دوره خاص
	 **/
	public $courses_yes_no;
	/**
	 * انتخاب دپارتمان
	 **/
	public $plan_id;
	/**
	 * انتخاب دوره
	 **/
	public $course_id;
	/**
	 * کد تخفیف
	 **/
	public $code;
	public $amount;

	public function model() {
		return new \model\Discounts();
	}

	public function apiFormat(): array {
		return [
			'id'        => $this->discount_id,
			'type'      => $this->type == 1 ? 'percent' : "price",
			'code'      => $this->code,
			'amount'    => (int)$this->amount,
			'use'       => (int)$this->use,
			'expiresAt' => (int)$this->expire_date,
		];
	}

	protected function dictionary(): array {
		return [
			'discount_id'    => 'discount_id',
			'type'           => 'discount_type',
			'use'            => 'discount_use',
			'number'         => 'discount_number',
			'expire_date'    => 'discount_expire_date',
			'courses_yes_no' => 'discount_courses_yes_no',
			'plan_id'        => 'plan_id',
			'course_id'      => 'course_id',
			'code'           => 'discount_code',
			'amount'         => 'discount_amount',
		];
	}
}
