<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;
use model\Bookmarks;
use model\Comments;
use model\Likes;
use model\Views;

class EpisodesEntity extends EntityScheme {
	public $episode_id;
	/**
	 * انتخاب داستان
	 **/
	public $story_id;
	/**
	 * اپیزود چندم ؟
	 **/
	public $number;
	/**
	 * محتوای اپیزود
	 **/
	public $content;
	public $date;

	public function model() {
		return new \model\Episodes();
	}

	public function toOption(): Option {
		return HtmlTags::Option()->Value($this->episode_id)->Content($this->number);
	}

	public function apiFormat(bool $hasAccess = true, $userId = 0,bool $isBookmarked = false): array {
		$isFree = (int)$this->number <= 3;
		if (!$isBookmarked) {
			$isBookmarked = Bookmarks::Db()->where([
					'story_id'   => $this->story_id,
					'episode_id' => $this->episode_id,
					'user_id'    => $userId,
				])->rowCount() > 0;
		}
		$isLiked = Likes::Db()->where([
				'story_id'   => $this->story_id,
				'episode_id' => $this->episode_id,
				'user_id'    => $userId,
			])->rowCount() > 0;

		$likes = Likes::Db()->where([
			'story_id'   => $this->story_id,
			'episode_id' => $this->episode_id,
		])->rowCount();
		$comments = Comments::Db()->where([
			'story_id'   => $this->story_id,
			'episode_id' => $this->episode_id,
		])->rowCount();
		$views = Views::Db()->where([
			'story_id'     => $this->story_id,
			'content_id'   => $this->episode_id,
			'content_type' => 'story',
		])->rowCount();
		return [
			'id'           => (int)$this->episode_id,
			'number'       => (int)$this->number,
			'content'      => $this->content,
			'date'         => (int)$this->date,
			'isBookmarked' => $isBookmarked,
			'isLiked'      => $isLiked,
			'isFree'       => $isFree,
			'isLocked'     => !$isFree && !$hasAccess,

			'likes'    => $likes,
			'comments' => $comments,
			'views'    => $views,
		];
	}

	protected function dictionary(): array {
		return [
			'episode_id' => 'episode_id',
			'story_id'   => 'story_id',
			'number'     => 'episode_number',
			'content'    => 'episode_content',
			'date'       => 'episode_date',
		];
	}
}
