<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Events;

class ParticipationsEntity extends EntityScheme {
	public $participation_id;
	/**
	 * تعداد ورودی
	 **/
	public $count;
	/**
	 * کاربر
	 **/
	public $user_id;
	/**
	 * هزینه ورودی
	 **/
	public $cost;
	/**
	 * رویداد
	 **/
	public $event_id;

	public function model() {
		return new \model\Participations();
	}

	public function apiFormat(): array {
		$event = Events::get($this->event_id);
		return [
			'id'        => $this->participation_id,
			'count'     => $this->count,
			'cost'      => $this->cost,
			'createdAt' => strtotime($this->created_at) * 1000,
			'event'     => $event instanceof EventsEntity ? $event->apiFormat() : null,
		];
	}

	protected function dictionary(): array {
		return [
			'participation_id' => 'participation_id',
			'count'            => 'participation_count',
			'user_id'          => 'user_id',
			'cost'             => 'participation_cost',
			'event_id'         => 'event_id',
		];
	}
}
