<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class PointsEntity extends EntityScheme {
	public $point_id;
	/**
	 * موقعیت
	 **/
	public $cause;
	/**
	 * کاربر
	 **/
	public $user_id;
	/**
	 * امتیاز
	 **/
	public $score;

	public function model() {
		return new \model\Points();
	}

	public function apiFormat(): array {
		return [
			'id'        => $this->point_id,
			'cause'     => $this->cause,
			'score'     => $this->score,
			'createdAt' => strtotime($this->createdAt) * 1000,
		];
	}

	protected function dictionary(): array {
		return [
			'point_id' => 'point_id',
			'cause'    => 'point_cause',
			'user_id'  => 'user_id',
			'score'    => 'point_score',
		];
	}
}
