<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class RewardsEntity extends EntityScheme {
	public $reward_id;
	/**
	 * عنوان جایزه
	 **/
	public $name;
	public $meta;
	/**
	 * دسته بندی
	 **/
	public $category_id;
	/**
	 * امتیاز مورد نیاز
	 **/
	public $required_points;
	/**
	 * تصویر
	 **/
	public $cover;
	/**
	 * توضیحات
	 **/
	public $text;

	public function model() {
		return new \model\Rewards();
	}

	public function apiFormat(): array {
		return [
			'id'     => $this->reward_id,
			'name'   => $this->name,
			'points' => $this->required_points,
			'cover'  => __IMAGES__ . 'Rewards/' . $this->cover,
			'text'   => $this->text,
		];
	}

	protected function dictionary(): array {
		return [
			'reward_id'       => 'reward_id',
			'name'            => 'reward_name',
			'meta'            => 'reward_meta',
			'category_id'     => 'reward_category_id',
			'required_points' => 'reward_required_points',
			'cover'           => 'reward_cover',
			'text'            => 'reward_text',
		];
	}
}
