<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\AudioBooks;
use model\Files;
use model\Stories;

class MembershipsEntity extends EntityScheme {
	public $membership_id;
	public $name;
	public $icon_id;
	public $story_ids;
	public $audio_book_ids;
	public $price;
	public $benefits;
	public $details;
	public $duration;

	public function model(): \model\Memberships {
		return new \model\Memberships();
	}

	public function apiFormat(): array {
		$icon = Files::get($this->icon_id);

		return [
			'id'         => $this->membership_id,
			'name'       => $this->name,
			'icon'       => $icon instanceof FilesEntity ? $icon->apiFormat() : null,
			'price'      => (int)$this->price,
			'details'    => $this->details . '',
			'duration'   => $this->duration,
		];
	}

	protected function dictionary(): array {
		return [
			'membership_id' => 'membership_id',
			'name'          => 'membership_name',
			'icon_id'       => 'icon_id',
			'price'         => 'membership_price',
			'benefits'      => 'membership_benefits',
			'details'       => 'membership_details',
			'duration'      => 'membership_duration',
		];
	}
}
