<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class PoemLanguagesEntity extends EntityScheme {
	public $poem_language_id;
	/**
	 * نام
	 **/
	public $name;

	public function model() {
		return new \model\PoemLanguages();
	}

	public function toOption(): Option {
		return HtmlTags::Option()->Value($this->poem_language_id)->Content($this->name);
	}

	public function apiFormat(): array {
		return [
			'id'   => $this->poem_language_id,
			'name' => $this->name,
		];
	}

	protected function dictionary(): array {
		return [
			'poem_language_id' => 'poem_language_id',
			'name'             => 'poem_language_name',
		];
	}
}
