<?php
namespace model\Entity;
use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class PoeticFormsEntity extends EntityScheme {
    public $poetic_form_id;
	/**
	عنوان
	**/
	public $name;
	/**
	توضیحات
	**/
	public $details;

    public function model() {
        return new \model\PoeticForms();
    }
    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->poetic_form_id)->Content($this->name);
    }


	public function apiFormat(): array {
		return [
			'id'      => $this->poetic_form_id,
			'name'    => $this->name,
			'details' => $this->details,
		];
	}

    protected function dictionary(): array {
        return  [
            'poetic_form_id' => 'poetic_form_id','name' => 'poetic_form_name','details' => 'poetic_form_details',
        ];
    }
}
