<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class PoeticStylesEntity extends EntityScheme {
	public $poetic_style_id;
	/**
	 * عنوان
	 **/
	public $name;
	/**
	 * توضیحات
	 **/
	public $style_details;

	public function model() {
		return new \model\PoeticStyles();
	}

	public function apiFormat(): array {
		return [
			'id'      => $this->poetic_style_id,
			'name'    => $this->name,
			'details' => $this->style_details,
		];
	}

	protected function dictionary(): array {
		return [
			'poetic_style_id' => 'poetic_style_id',
			'name'            => 'poetic_style_name',
			'style_details'   => 'poetic_style_details',
		];
	}
}
