<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class TimePeriodsEntity extends EntityScheme {
	public $time_period_id;
	/**
	 * عنوان
	 **/
	public $name;
	/**
	 * توضیحات
	 **/
	public $period_details;

	public function model() {
		return new \model\TimePeriods();
	}

	public function apiFormat(): array {
		return [
			'id'      => $this->time_period_id,
			'name'    => $this->name,
			'details' => $this->period_details,
			'poets'   => [],
		];
	}

	protected function dictionary(): array {
		return [
			'time_period_id' => 'time_period_id',
			'name'           => 'time_period_name',
			'period_details' => 'time_period_details',
		];
	}
}
