<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;
use model\Ads;
use model\Cities;
use model\Countries;
use model\Jobs;
use model\Plans;
use model\States;

class UsersEntity extends EntityScheme {
	public $user_id;
	public $name;
	public $mobile;
	public $membership_id;
	public $referrer;
	public $image;
	public $last_notif_seen_date;
	public $password;
	public $login_date;
	public $firebase_token;
	public $token;
	/**
	 * @var void
	 */
	public $points;

	public function model(): \model\Users {
		return new \model\Users();
	}

	public function apiFormat(): array {

		$membership = null;

		if ($this->membership_expired_at > 0 and $this->membership_activated_at > 0 and $this->membership_expired_at > time()) {
			$membership = \model\Memberships::get($this->membership_id);
			if ($membership instanceof MembershipsEntity) {
				$membership = $membership->apiFormat();
				$membership['createdAt'] = $this->membership_activated_at * 1000;
				$membership['expiresAt'] = $this->membership_expired_at * 1000;
				// Calculate daysPassed and daysLeft
				$now = time() * 1000; // Current timestamp in milliseconds
				$daysPassed = floor(($now - $membership['createdAt']) / (1000 * 60 * 60 * 24)); // Milliseconds to days
				$daysLeft = floor(($membership['expiresAt'] - $now) / (1000 * 60 * 60 * 24)); // Milliseconds to days

// Ensure daysLeft is not negative
				if ($daysLeft < 0) {
					$daysLeft = 0;
				}
				if ($daysPassed <= 1) {
					$daysPassed = 1;
				}

				$membership['daysPassed'] = $daysPassed;
				$membership['daysLeft'] = $daysLeft;
				$membership['name'] .= " تا " . jdate("Y/m/d", $this->membership_expired_at);
			}
		}
		return [
			'id'           => $this->user_id,
			'name'         => $this->name . '',
			'time'         => time(),
			'mobile'       => $this->mobile ?? $this->user_email,
			'image'        => is_file(__SOURCE__ . 'images/Users/' . $this->user_id . '.jpg') ? __IMAGES__ . 'Users/' . $this->user_id . '.jpg' : __IMAGES__ . 'Users/placeholder.jpg',
			'cardNumber'   => '6037691559008099',
			'points'       => (int)$this->points,
			'cryptoWallet' => [
				[
					'name'    => 'Tron',
					'symbol'  => 'TRC20',
					'network' => 'tron',
					'wallet'  => 'TSqCbdRbET1TicF8Fzp7ccAP2rkUcCsunb',
				],
				[
					'name'    => 'Polygon',
					'symbol'  => 'PoS',
					'network' => "polygon",
					'wallet'  => '0xDD6154BE7A407D360a2844AcE658cE5100c24099',
				],
			],
			'membership'   => $membership,
		];
	}

	public function toOption(): Option {
		return HtmlTags::Option()->Value($this->user_id)->Content($this->name . ' - ' . $this->mobile);
	}

	public function commentFormat(): array {
		return [
			'id'     => $this->user_id,
			'avatar' => $this->image(),
			'name'   => $this->name,
		];
	}

	public function image(): string {
		return is_file(__SOURCE__ . 'images/Users/' . $this->user_id . '.jpg') ? __IMAGES__ . '/Users/' . $this->user_id . '.jpg' : __IMAGES__ . '/Users/placeholder.jpg';
	}

	protected function dictionary(): array {
		return [
			'user_id'  => 'user_id',
			'name'     => 'user_name',
			'password' => "user_password",
			'referrer' => "user_referrer",
			'points'   => 'user_points',
		];
	}
}
