<?php

namespace fwTools\all;

use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use RegexIterator;
use stdClass;

class Models {
	
	public function getAll() {
		foreach (new RegexIterator(new RecursiveIteratorIterator(new RecursiveDirectoryIterator(__SOURCE__ . 'models/')), '/\.php$/') as $phpFile) {
			$obj = new stdClass();
			$obj->name = basename($phpFile->getFileName(), '.php');
			$class = str_replace('.php', '', $phpFile->getFileName());
			$class = "\model\\$class";
			if (class_exists($class)) {
				$class = new $class();
				$obj->key = $class->_key;
				yield $obj;
			}
		}
	}
}
