<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class DistrictsMigration extends Migratable {
    const modelName = 'Districts';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('district_id');
			$blueprint->VarChar('district_name')->Len(150);
			$blueprint->Int('state_id')->Len(150);
			$blueprint->Int('city_id')->Len(150);
			$blueprint->Text('district_polygon');
			$blueprint->Text('created_at');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
