<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ProductsMigration extends Migratable {
    const modelName = 'Products';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('product_id');
			$blueprint->VarChar('product_name')->Len(150);
			$blueprint->Int('product_price')->Len(150);
			$blueprint->Text('product_details');
			$blueprint->Text('product_colors');
			$blueprint->Text('product_attributes');
			$blueprint->Text('product_images');
			$blueprint->Int('category_id')->Len(150);
			$blueprint->Int('sub_category_id')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
