<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ServicesMigration extends Migratable {
    const modelName = 'Services';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('service_id');
			$blueprint->VarChar('service_name')->Len(150);
			$blueprint->Int('category_id')->Len(150);
			$blueprint->Int('sub_category_id')->Len(150);
			$blueprint->Text('service_details');
			$blueprint->Int('file_ids')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
