<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class AddOnsMigration extends Migratable {
    const modelName = 'AddOns';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('add_on_id');
			$blueprint->VarChar('addon_title')->Len(150);
			$blueprint->Int('service_id')->Len(150);
			$blueprint->Int('addon_price')->Len(150);
			$blueprint->VarChar('addon_pic')->Len(150);
			$blueprint->VarChar('addon_details')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
