<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class OrdersMigration extends Migratable {
    const modelName = 'Orders';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('order_id');
			$blueprint->Int('user_id')->Len(150);
			$blueprint->Int('user_address_id')->Len(150);
			$blueprint->Int('product_id')->Len(150);
			$blueprint->VarChar('order_fee')->Len(150);
			$blueprint->Int('order_total')->Len(150);
			$blueprint->Int('order_discount')->Len(150);
			$blueprint->Int('order_payable')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
