<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ArtistsMigration extends Migratable {
    const modelName = 'Artists';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('artist_id');
			$blueprint->VarChar('artist_name')->Len(150);
			$blueprint->VarChar('artist_image')->Len(150);
			$blueprint->VarChar('artist_job')->Len(150);
			$blueprint->Text('artist_bio');
			$blueprint->VarChar('artist_share')->Len(150);
			$blueprint->VarChar('artist_alive')->Len(150);
			$blueprint->VarChar('artist_activity')->Len(150);
			$blueprint->VarChar('artist_social_media')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
