<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class PoemsMigration extends Migratable {
    const modelName = 'Poems';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('poem_id');
			$blueprint->VarChar('poem_name')->Len(150);
			$blueprint->Int('poet_id')->Len(150);
			$blueprint->Int('poem_category_id')->Len(150);
			$blueprint->Int('poem_language_id')->Len(150);
			$blueprint->Int('poetic_form_id')->Len(150);
			$blueprint->Int('poetic_meter_id')->Len(150);
			$blueprint->Text('poem_text');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
