<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class AudioBooks extends View {

	public $SingularName = 'کتاب صوتی';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('نام کتاب'),
																	HtmlTags::Th('تاریخ شروع کتاب'),
																	HtmlTags::Th('وضعیت کتاب'),
																	HtmlTags::Th('اشتراک مورد نیاز'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'audio_book_name',
																	'audio_book_start_date',
																	'is_ended' => function ($item) {
																		return $item == 1 ? "بله" : "خیر";
																	},
																	'membership_id' => function($planId){
																		return \model\Memberships::get($planId)->membership_name;
																	}
																])
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('نام کتاب') .
										$this->Html()->Input('audio_book_name') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب هنرمند') .
										$this->Html()->Select('artist_id', 'artist_id', \model\Artists::toOption()) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('کاور کتاب') .
										$this->Html()->ImageInput('audio_book_cover', 'image/jpeg', 150, 150) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب برچسب ها') .
										$this->Html()->Select('label_ids[]', 'label_ids', \model\Labels::toOption(),true) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('پایان یافته') .
										$this->Html()->Select('is_ended', 'is_ended', HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید') . HtmlTags::Option()->Value(1)->Content("بله") . HtmlTags::Option()->Value(0)->Content("خیر")) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('کتاب روزانه') .
										$this->Html()->Select('is_daily', "is_daily", HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید') . HtmlTags::Option()->Value(1)->Content("بله") . HtmlTags::Option()->Value(0)->Content("خیر")) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('اشتراک مورد نیاز') .
										$this->Html()->Select('membership_id', 'membership_id', \model\Memberships::toOption()) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        