$(function (){
    $(".deActiveComment").on('click',function (){
        let status = '1'
        let id = $(this).data('id')

        Swal.fire({
            icon: "question",
            title: "غیر فعال سازی",
            text: "آیا از غیر فعال سازی این کامنت برای نمایش در اپلیکیشن مطمئنید؟",
            confirmButtonText: "بله",
            confirmButtonColor:"green",
            showCancelButton: 'true',
            cancelButtonText:'انصراف',
            cancelButtonColor:'gray',
            preConfirm:()=>{
                $.ajax({
                    url:"controllers/Comments/Comments",
                    type:"POST",
                    data:{
                        id,
                        status,
                        controller_type:"changeStatus"
                    },success:res=>{
                        if (res==="1"){
                            $("#fw_refresh_btn").click()
                        }else {
                            Swal.fire({
                                icon:"error",
                                title:"خطا",
                                text:"غیرفعال سازی کامنت با خطا مواجه شد",
                                confirmButtonText:"فهمیدم"
                            })
                        }
                    }

                })
            }

        })



    })

    $(".activeComment").on('click',function (){
        let status = '0'
        let id = $(this).data('id')
        Swal.fire({
            icon: "question",
            title: "فعال سازی",
            text: "آیا از فعال سازی این کامنت برای نمایش در اپلیکیشن مطمئنید؟",
            confirmButtonText: "بله",
            confirmButtonColor:"green",
            showCancelButton: 'true',
            cancelButtonText:'انصراف',
            cancelButtonColor:'red',
            reverseButtons:'true',
            preConfirm:()=>{
                $.ajax({
                    url:"controllers/Comments/Comments",
                    type:"POST",
                    data:{
                        id,
                        status,
                        controller_type:"changeStatus"
                    },success:res=>{
                        if (res==="1"){
                            $("#fw_refresh_btn").click()
                        }else {
                            Swal.fire({
                                icon:"error",
                                title:"خطا",
                                text:"فعال سازی کامنت با خطا مواجه شد",
                                confirmButtonText:"فهمیدم"
                            })
                        }
                    }

                })
            }

        })


    })

    $(".replies").on('click',function (){
        let id = $(this).data('id'), name = $(this).data('title');
        $("#repliesModalTitle").text(name);
        $.loader();
        $.ajax({
            url: "controllers/Comments/Comments",
            type: "POST",
            data: {
                controller_type: "fetchReplies",
                id,
            },
            success: res => {
                $.loader();

                $("#repliesModal").find('.modal-body').html(res);
                $('#repliesModal').modal('show');
            }
        })
    })

})