<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Comments extends View
{

    public $SingularName = 'کامنت';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('کاربر'),
                                                                    HtmlTags::Th('نظر'),
                                                                    HtmlTags::Th('محصول'),
                                                                    HtmlTags::Th('وضعیت'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'user_id' => function($userId){
                                                                        $user = \model\Users::get($userId);
                                                                        return $user->name. " (" . $user->mobile . ")";
                                                                    },
                                                                    'comment_text',
                                                                    function($item){
                                                                        if ($item->story_id != 0){
                                                                            $storyName = \model\Stories::get($item->story_id)->name;
                                                                            return "داستان : ".$storyName;
                                                                        }elseif ($item->book_id != 0){
                                                                            $bookName = \model\Books::get($item->book_id)->name;
                                                                            return "کتاب : ".$bookName;
                                                                        }elseif ($item->audio_book_id != 0){
                                                                            $audioBookName = \model\AudioBooks::get($item->audio_book_id)->name;
                                                                            return "کتاب صوتی : ".$audioBookName;
                                                                        }else{
                                                                            return "نامشخص";
                                                                        }
                                                                    },
                                                                    'status' => function ($item) {
                                                                        if ($item == 1) {
                                                                            return HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
                                                                                "کامنت فعال"
                                                                            );
                                                                        } else {
                                                                            return HtmlTags::Span('.badge.badge-pill.badge-danger.p-2')->Content(
                                                                                "کامنت غیر فعال"
                                                                            );
                                                                        }
                                                                    }
                                                                ], false, false, false, false,function ($row) {
                                                                    if ($row->status == '1') {
                                                                        return HtmlTags::Button('.btn.btn-outline-danger.m-2.p-2.deActiveComment')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('غیر فعال سازی کامنت'),
                                                                        )->Data_('id', $row->comment_id);
                                                                    } else {
                                                                        return HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.activeComment')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('فعال سازی کامنت'),
                                                                        )->Data_('id', $row->comment_id);
                                                                    }
                                                                }, function ($row) {
                                                                    return HtmlTags::Button('.btn.btn-outline-primary.m-2.p-2.replies')->Content(
                                                                        HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Comments()),
                                                                    )->Data_('toggle', 'tooltip')
                                                                        ->Data_('placement', 'top')
                                                                        ->Data_('id', $row->comment_id)->Data_('title', $row->comment_text)
                                                                        ->Title('نمایش پاسخ ها');
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                ). $this->buildRepliesModal();
    }

    private function buildRepliesModal()
    {
        return HtmlTags::Div(".modal.fade#repliesModal")->Content(
            HtmlTags::Div('.modal-dialog.modal-xl')->Content( // تغییر به modal-xl برای افزایش عرض
                HtmlTags::Div('.modal-content')->Content(
                    HtmlTags::Div('.modal-header')->Content(
                        HtmlTags::H4('.modal-title#repliesModalTitle')->Content(),
                        HtmlTags::Div('.pull-left')->Content(
                            HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
                        )
                    ),
                    HtmlTags::Form()->Content(
                        HtmlTags::Div('.modal-body.d-flex.flex-wrap.justify-center')->Content(
                            HtmlTags::Div('.table-responsive')->Content( // اضافه کردن table-responsive
                                HtmlTags::Table('.table.table-bordered.table-striped.w-100')->Content(  // اضافه کردن w-100 برای جدول
                                // محتوای جدول
                                )
                            )
                        )
                    )
                )
            )
        );

    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب کاربر') .
                                        $this->Html()->Select('user_id', 'user_id', \model\Users::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('امتیاز') .
                                        $this->Html()->Select('comment_rate', 'comment_rate',
                                            HtmlTags::Option()->Value(1)->Content("★").
                                            HtmlTags::Option()->Value(2)->Content("★★").
                                            HtmlTags::Option()->Value(3)->Content("★★★").
                                            HtmlTags::Option()->Value(4)->Content("★★★★").
                                            HtmlTags::Option()->Value(5)->Content("★★★★★")
                                        ) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('پاسخ به کامنت') .
                                        $this->Html()->Select('reply_id', 'reply_id', \model\Comments::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب داستان') .
                                        $this->Html()->Select('story_id', 'story_id', \model\Stories::toOption(),false,false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب کتاب') .
                                        $this->Html()->Select('book_id', 'book_id', \model\Books::toOption(),false,false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب کتاب صوتی') .
                                        $this->Html()->Select('audio_book_id', 'audio_book_id', \model\AudioBooks::toOption(),false,false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('کامنت') .
                                        $this->Html()->TextArea('comment_text') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        