<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Discounts extends View {

	public $SingularName = 'کد تخفیف';
	public $PluralName = 'کد های تخفیف';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('کد تخفیف'),
                                                                    HtmlTags::Th('تعداد استفاده هر کاربر'),
                                                                    HtmlTags::Th('تعداد کدتخفیف'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'discount_code',
																	'discount_use',
																	'discount_number',
																])
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('نوع تخفیف') .
										$this->Html()->Select('discount_type', 'discount_type',
											HtmlTags::Option()->Value(1)->Content('درصد') .
											HtmlTags::Option()->Value(2)->Content('مبلغ')
										) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('میزان تخفیف') .
										HtmlTags::Div('.w-100')->Id('discount_amount_percent')->Content(
											$this->Html()->Percent('discount_amount', 'discount_amount_percent_input','',false)
										) .
										HtmlTags::Div('.w-100')->Id('discount_amount_price')->Content(
											$this->Html()->Price('discount_amount', 'discount_amount_price_input','تومان','',false)
										) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(2) .
										$this->Html()->Label('تعداد استفاده هر کاربر') .
										$this->Html()->Number('discount_use') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(2) .
										$this->Html()->Label('تعداد کدتخفیف') .
										$this->Html()->Number('discount_number') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(2) .
										$this->Html()->Label('تاریخ انقضا کد') .
										$this->Html()->Input('discount_expire_date') .
										$this->Html()->FormGroupEnd() .
//										$this->Html()->FormGroupStart(2) .
//										$this->Html()->Label('استفاده کد برای اشتتراک خاص') .
//										$this->Html()->Input('discount_courses_yes_no', 'discount_courses_yes_no') .
//										$this->Html()->FormGroupEnd() .
//										$this->Html()->FormGroupStart(4, 'hideMain') .
//										$this->Html()->Label('انتخاب اشتراک') .
//										$this->Html()->Select('plan_id', 'plan_id', \model\Plans::toOption(),false,false) .
//										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(6) .
										$this->Html()->Label('کد تخفیف') .
										$this->Html()->Input('discount_code', 'discount_code', $this->getData()->discount_code ?? UniqueOfClass(new \model\Discounts(), 'discount_code', false, 8, false))->Readonly() .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
