<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\EventsEntity;
use model\Entity\UsersEntity;
use View;

class Participations extends View {

	public $SingularName = 'ثبت نام در رویداد';
	public $PluralName = 'ثبت نام ها در رویداد';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('کاربر'),
																	HtmlTags::Th('تعداد ورودی'),
																	HtmlTags::Th('هزینه ورودی'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'user_id' => function ($id) {
																		$user = \model\Users::get($id);
																		if ($user instanceof UsersEntity) {
																			return $user->mobile . ' - ' . $user->name;
																		}
																		return $id.'';
																	},
																	'event_id' => function ($id) {
																		$event = \model\Events::get($id);
																		if ($event instanceof EventsEntity) {
																			return $event->name;
																		}
																		return $id.'';
																	},
																	'participation_count',
																	'participation_cost'
																])
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('تعداد ورودی') .
										$this->Html()->Input('participation_count') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('کاربر') .
										$this->Html()->Select('user_id', 'user_id', \model\Users::toOption()) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('هزینه ورودی') .
										$this->Html()->Price('participation_cost', 'participation_cost') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('رویداد') .
										$this->Html()->Select('event_id', 'event_id', \model\Events::toOption()) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        