<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Table;
use FwHtml\FontAwesome;
use View;

class Memberships extends View {

	public $SingularName = 'عضویت';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('عنوان'), HtmlTags::Th('قیمت عضویت (ماهانه)'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'membership_name',
																	'price_format' => 'membership_price'
																])
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		$this->initDataTable = false;
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('عنوان') .
										$this->Html()->Input('membership_name') .
										$this->Html()->FormGroupEnd() .


										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('قیمت عضویت (ماهانه)') .
										$this->Html()->Price('membership_price') .
										$this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('مدت اشتراک') .
                                        $this->Html()->Price('membership_duration','membership_duration','روز') .
                                        $this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('آیکون') .
										$this->FilePicker('icon_id') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('داستان') .
										$this->Html()->Select('story_ids[]', 'story_ids',\model\Stories::toOption(false),true) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('کتاب صوتی') .
										$this->Html()->Select('audio_book_ids[]', 'audio_book_ids',\model\AudioBooks::toOption(false),true) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('توضیحات') .
										$this->Html()->TextArea('membership_details') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12, 'mt-2', 'showFields') .
										HtmlTags::Label('.w-100')->Content(
											"مزایا",
											HtmlTags::Button('.btn.mr-2.btn-success.p-2#addField')->Content(
												HtmlTags::I('.ml-1')->Class(FontAwesome::Plus()),
												"افزودن",
											)->Type('button'),
										),
										$this->buildTable() .
										$this->Html()->FormGroupEnd() .

										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	private function buildTable(): Table {
		return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
			HtmlTags::Thead()->Content(
				HtmlTags::Th()->Content("#"),
				HtmlTags::Th("مقدار"),
				HtmlTags::Th("عملیات"),
			),
			HtmlTags::Tbody("#fieldsBody")->Content(
				function () {
					$data = $this->getData();
					if (isset($data)) {
						$fields = json_decode($this->getData()->membership_benefits . '', true);
						$output = [];
						if (is_array($fields)) {
							foreach ($fields as $field) {
								$output[] = HtmlTags::Tr()->Content(
									HtmlTags::Td()->Content(
										HtmlTags::Td()->Content(
											HtmlTags::Input('.form-control')->Type('text')->Name('membership_benefits[]')->Value($field)
										),
										HtmlTags::Td()->Content(
											HtmlTags::Button('.btn.btn-danger.p-2.deleteField')->Type('button')->Content(
												HtmlTags::I('.fa.fa-trash')
											)
										)
									)
								);
							}
						}
						return implode('', $output);
					}
					return "";
				}

			),
		);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        