<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Onboardings extends View {

	public $SingularName = 'صفحه';
	public $PluralName = 'صفحات استارت اپلیکیشن';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('عنوان صفحه'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show(['onboarding_name'])
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(6) .
										$this->Html()->Label('عنوان صفحه') .
										$this->Html()->Input('onboarding_name') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(6) .
										$this->Html()->Label('تصویر') .
										$this->FilePicker('file_id') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('توضیحات') .
										$this->Html()->TextArea('onboarding_details') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        