<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use model\Entity\BooksEntity;
use model\Entity\OrdersEntity;
use model\Entity\ProductsEntity;
use View;

class Orders extends View
{

    public $SingularName = 'سفارش';
    public $PluralName = 'سفارشات فروشگاه';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('کد سفارش'),
                                                                    HtmlTags::Th('سفارشات'),
                                                                    HtmlTags::Th('کاربر'),
                                                                    HtmlTags::Th('آدرس'),
                                                                    HtmlTags::Th('وضعیت'),
                                                                    HtmlTags::Th('تاریخ ثبت'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'order_id',
                                                                    'book_id' => function ($bookIds) {
                                                                        $bookIdsArray = json_decode($bookIds);
                                                                        $bookNames = [];
                                                                        $bookCounts = [];
                                                                        foreach ($bookIdsArray as $id => $count) {
                                                                            $book = \model\Books::get($id);
                                                                            if ($book) {
                                                                                $bookNames[] = $book->book_name;
                                                                                $bookCounts[] = $count;
                                                                            }
                                                                        }
                                                                        $outputParts = [];
                                                                        foreach ($bookNames as $index => $bookName) {
                                                                            $count = $bookCounts[$index];
                                                                            $outputParts[] = $bookName . " (" . $count . " عدد)";
                                                                        }
                                                                        $finalOutput = implode("<hr>", $outputParts);
                                                                        return $finalOutput;
                                                                    },
                                                                    'user_id' => function ($id) {
                                                                        $user = \model\Users::get($id);
                                                                        return $user->name . ' - ' . $user->mobile;
                                                                    },
                                                                    'user_address_id' => function ($addressId) {
                                                                        $address = \model\UserAddresses::get($addressId);
                                                                        if ($address){
                                                                            $text = $address->user_address_text?" ".$address->user_address_text:" ثبت نشده ";
                                                                            $floor = $address->user_address_floor?" ".$address->user_address_floor:" ثبت نشده ";
                                                                            $zipCode = $address->user_address_zip_code?" ".$address->user_address_zip_code:" ثبت نشده ";
                                                                            $result = HtmlTags::Span('.badge.badge-info.p-2')->Content("آدرس : ").$text."<br>".HtmlTags::Span('.badge.badge-info.p-2.m-1')->Content("واحد و طبقه : ").$floor."<br>".HtmlTags::Span('.badge.badge-info.p-2')->Content("کد پستی : ").$zipCode;

                                                                        }else{
                                                                            $result = HtmlTags::Span('.badge.badge-danger.p-4')->Content("ثبت نشده");
                                                                        }
                                                                        return $result;

                                                                    },
                                                                    'order_status' => function ($status) {
                                                                        return OrdersEntity::getStatusStatic($status);
                                                                    },
                                                                    'created_at' => function($time){
                                                                        return jdate('Y-m-d H:i',strtotime($time));
                                                                    },
                                                                ], false,true,false,false,function ($row){
                                                                    $status = $row->order_status;
                                                                    switch ($status){
                                                                        case 0:
                                                                            return HtmlTags::Button('.btn.btn-outline-success.p-2.m-2.confirmOrder')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                            )->Data_('id', $row->order_id)->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('تایید سفارش');
                                                                            break;
                                                                        case 1:
                                                                            return HtmlTags::Button('.btn.btn-outline-primary.p-2.m-2.sentOrder')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Truck())
                                                                            )->Data_('id', $row->order_id)->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('ارسال سفارش');
                                                                            break;
                                                                        case 2:
                                                                            return HtmlTags::Button('.btn.btn-outline-info.p-2.m-2.deliveredOrder')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Book())
                                                                            )->Data_('id', $row->order_id)->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('تحویل سفارش به مشتری');
                                                                            break;
                                                                        case 3:
                                                                            return HtmlTags::Button('.btn.btn-outline-secondary.p-2.m-2.returnedOrder')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Backward())
                                                                            )->Data_('id', $row->order_id)->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('مرجوع سفارش');
                                                                            break;

                                                                    }
                                                                },function ($row){
                                                                    $status = $row->order_status;
                                                                    if ($status == 0 || $status == 1){
                                                                        return HtmlTags::Button('.btn.btn-outline-danger.p-2.m-2.cancelOrder')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                        )->Data_('id', $row->order_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('لغو سفارش');
                                                                    }
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function Form()
    {

        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب کاربر') .
                                        $this->Html()->Select('user_id', 'user_id', \model\Users::toOption(), false, true, true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('انتخاب آدرس') .
                                        $this->Html()->Select('user_address_id', 'user_address_id', \model\UserAddresses::toOption(), false, true, true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('وضعیت') .
                                        $this->Html()->Select('order_status', 'order_status', collect(OrdersEntity::$statusList)->map(function ($item, $key) {
                                            return HtmlTags::Option()->Value($key)->Content($item);
                                        })->join('')) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('هزینه ارسال') .
                                        $this->Html()->Price('order_fee', 'order_fee', '$', '', true, true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('تخفیف') .
                                        $this->Html()->Price('order_discount', 'order_discount', '$', '', true, true) .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('مجموع قیمت محصولات') .
                                        $this->Html()->Price('order_total', 'order_total', '$', '', true, true) .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('مبلغ قابل پرداخت') .
                                        $this->Html()->Price('order_payable', 'order_payable', '$', '', true, true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('محصولات') .
                                        $this->buildTable(),
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    private function buildTable(): \FwHtml\Elements\Tags\Table
    {

        $this->initDataTable = false;
        return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
            HtmlTags::Thead()->Content(
                HtmlTags::Th()->Content("#"),
                HtmlTags::Th("محصول"),
                HtmlTags::Th("تعداد"),
            ),
            HtmlTags::Tbody("#fieldsBody")->Content(
                function () {
                    $data = $this->getData();
                    if (isset($data)) {
                        $products = json_decode($this->getData()->book_id . '', true);
                        $output = [];
                        if (is_array($products)) {
                            $counter = 0;
                            foreach ($products as $id => $count) {
                                $counter++;
                                $product = \model\Books::get($id);
                                if ($product instanceof BooksEntity) {
                                    $output[] = HtmlTags::Tr()->Content(
                                        HtmlTags::Td()->Content(
//											HtmlTags::Td()->Content(
//												$counter.'',
//											),
                                            HtmlTags::Td()->Content(
                                                $product->name
                                            ),
                                            HtmlTags::Td()->Content(
                                                $count . ' عدد'
                                            ),
                                        )
                                    );
                                }
                            }
                        }
                        return implode('', $output);
                    }
                    return "";
                }

            ),
        );
    }


}
        