<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Poems extends View
{

    public $SingularName = 'شعر';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام شعر'), HtmlTags::Th('متن شعر'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['poem_name', 'poem_text'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات پایه') .
                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نام شعر') .
                                        $this->Html()->Input('poem_name') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('شاعر') .
                                        $this->Html()->Select('poet_id', 'poet_id', \model\Poets::toOption()) .
                                        $this->Html()->FormGroupEnd() .
                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('دسته بندی') .
                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('دسته بندی شعر') .
                                        $this->Html()->Select('', 'poem_category_id', \model\PoemCategories::toOption(),false,false,true,'form-control cat_id category') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->Input('poem_category_id','','',false,false,'d-none poemLastCatId') .


                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات شعر') .
                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('زبان شعر') .
                                        $this->Html()->Select('poem_language_id', 'poem_language_id', \model\PoemLanguages::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('قالب شعر') .
                                        $this->Html()->Select('poetic_form_id', 'poetic_form_id', \model\PoeticForms::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('وزن شعر') .
                                        $this->Html()->Select('poetic_meter_id', 'poetic_meter_id', \model\PoeticMeters::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('متن شعر') .
                                        $this->Html()->Input('poem_text') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        