<?php

namespace view;

use FwBase\Reports\ReportView;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\UsersEntity;
use model\PaymentTable;

class SaleReports extends ReportView {
	public $SingularName = 'تراکنش';
	public $PluralName = 'تراکنش ها';

	public function ReportFields(): array {
		return [
			$this->DateFromTo("date", 'تاریخ'),
			$this->SimpleSelect("user_id", 'انتخاب کاربر', \model\Users::toOption(false), 4),
			$this->SimpleSelect("payment_type", 'نوع پرداخت', HtmlTags::Option()->Value(1)->Content('خرید کتاب').HtmlTags::Option()->Value(2)->Content('خرید اشتراک'), 4),
			$this->SimpleSelect("payment_status", 'وضعیت پرداخت', HtmlTags::Option()->Value(1)->Content('پرداخت های موفق').HtmlTags::Option()->Value(2)->Content('پرداخت های ناموفق'), 4),
		];
	}

	public function thList(): \FwHtml\Elements\Tags\Tr {
		return HtmlTags::Tr()->Content(
			HtmlTags::Th()->Content("#"),
			HtmlTags::Th()->Content("کاربر"),
			HtmlTags::Th()->Content("نوع تراکنش"),
			HtmlTags::Th()->Content("مبلغ"),
			HtmlTags::Th()->Content("کد رهگیری"),
			HtmlTags::Th()->Content("تاریخ"),
			HtmlTags::Th()->Content("ساعت"),
			HtmlTags::Th()->Content("وضعیت"),
		);
	}

	public function toRow($order, $i): \FwHtml\Elements\Tags\Tr {
		/** @var UsersEntity $user */
		$user = \model\Users::get($order->user_id);
		$paymentData = json_decode($order->payment_data);
		return HtmlTags::Tr()->Content(
			HtmlTags::Td()->Content("$i"),
			HtmlTags::Td()->Content(($user instanceof UsersEntity ? $user->user_name . ' - (' . $user->mobile . ')' : "No User")),
			HtmlTags::Td()->Content(PaymentTable::getType($order->payment_type)),
			HtmlTags::Td()->Content(price_format($order->payment_amount / 10)),
			HtmlTags::Td()->Content($order->payment_resnum),
			HtmlTags::Td()->Content(jdate('Y/m/d', $order->payment_date)),
			HtmlTags::Td()->Content(jdate('H:i', $order->payment_date)),
			HtmlTags::Td()->Content(
				$order->payment_status == 1
					? HtmlTags::Span('.badge.badge-success.p-2')->Content(
					"پرداخت شده"
				)
					: HtmlTags::Span('.badge.badge-danger.p-2')->Content(
					"پرداخت نا موفق"
				)
			),
		);
	}

}
