<?php

namespace view;

use FwBase\Reports\ReportView;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\UsersEntity;
use model\PaymentTable;

class UserMembershipReports extends ReportView {
	public $SingularName = 'اشتراک';
	public $PluralName = 'اشتراک ها';

	public function ReportFields(): array {
		return [
			$this->SimpleSelect("user_id", 'انتخاب کاربر', \model\Users::toOption(false), 12),
		];
	}

	public function thList(): \FwHtml\Elements\Tags\Tr {
		return HtmlTags::Tr()->Content(
			HtmlTags::Th()->Content("#"),
			HtmlTags::Th()->Content("کاربر"),
			HtmlTags::Th()->Content("نوع اشتراک"),
			HtmlTags::Th()->Content("تاریخ خرید"),
			HtmlTags::Th()->Content("کد تاریخ انقضا"),
		);
	}

	public function toRow($order, $i): \FwHtml\Elements\Tags\Tr {
		/** @var UsersEntity $user */
		$user = \model\Users::get($order->user_id);
		$paymentData = json_decode($order->payment_data);
        $membershipName = \model\Memberships::get($paymentData->membershipId)->membership_name;
		return HtmlTags::Tr()->Content(
			HtmlTags::Td()->Content("$i"),
			HtmlTags::Td()->Content(($user instanceof UsersEntity ? $user->user_name . ' - (' . $user->mobile . ')' : "No User")),
			HtmlTags::Td()->Content($membershipName),
			HtmlTags::Td()->Content(jdate('Y/m/d',$order->payment_date)),
			HtmlTags::Td()->Content(jdate('Y/m/d',$order->payment_date + (30 * 86400))),
		);
	}

}
