<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class Notifications extends View {

	public $SingularName = 'نوتیفیکیشن';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('تیتر'),
																	HtmlTags::Th('متن'),
																	HtmlTags::Th('تاریخ ارسال'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'notification_title',
																	'notification_text',
																	'created_at' => function ($created) {
																		return jdate("Y/m/d H:i", strtotime($created));
																	}
																], true, false, false, true)
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('تیتر') .
										$this->Html()->Input('notification_title') .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('تصویر') .
										$this->FilePicker('notification_image') .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(6) .
										$this->Html()->Label('متن') .
										$this->Html()->TextArea('notification_text') .
										$this->Html()->FormGroupEnd() .
//										$this->Html()->FormGroupStart(6) .
//										$this->Html()->Label('محصول') .
//										$this->Html()->Select('product_id', 'product_id', HtmlTags::Option()->Value(0)->Content("No Product").\model\Products::toOption(false), false, false) .
//										$this->Html()->FormGroupEnd() .
//
//										$this->Html()->FormGroupStart(6) .
//										$this->Html()->Label('خدمت') .
//										$this->Html()->Select('service_id', 'service_id', HtmlTags::Option()->Value(0)->Content("No Service").\model\Services::toOption(false), false, false) .
//										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('کاربر ها') .
										$this->Html()->Select('user_id[]', 'user_id', HtmlTags::Option()->Value('all')->Content("همه کاربران") .
//											HtmlTags::Option()->Value('active')->Content("کاربران با اشتراک فعال").
//											HtmlTags::Option()->Value('nonactive')->Content("کاربران با اشتراک غیرفعال").
											\model\Users::toOption(false), true) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

}
        