$(function () {
    $(".confirmPayment").on('click', function () {
        let id = $(this).data('id');
        $.ajax({
            url: "controllers/Users/Users",
            type: "POST",
            data: {
                controller_type: "confirmPayment",
                paymentId: id,
            },
            success: res => {
                if (res === "1") {
                    Swal.fire({
                        icon: "success",
                        title: "خرید اشتراک",
                        text: 'خرید با موفقیت انجام شد',
                        showConfirmButton: false, showCloseButton: true,
                        onAfterClose: () => {
                            $("#fw_refresh_btn").click();
                        }
                    });
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "خرید اشتراک",
                        text: 'خرید با خطا مواجه شد',
                        confirmButtonText: "فهمیدم"
                    })
                }
            }
        })
    })
    $(".deletePayment").on('click',function (){
        let id = $(this).data('id');
        Swal.fire({
            title: "حذف پرداخت",
            text: "آیا مطمئن هستید",
            showCancelButton: true,
            confirmButtonText: 'تایید',
            cancelButtonText:'انصراف',
            confirmButtonColor:"green",
            cancelButtonColor:"red",
            reverseButtons: true,
            preConfirm: (text) => {
                $.ajax({
                    url: "controllers/Users/Users",
                    type: "POST",
                    data:{
                        controller_type: "deletePayment",
                        paymentId: id,
                    },
                    success:res=>{
                        if (res === "1") {
                            Swal.fire({
                                icon: "success",
                                title: "حذف پرداخت",
                                text: 'حذف با موفقیت انجام شد',
                                showConfirmButton: false, showCloseButton: true,
                                onAfterClose: () => {
                                    $("#fw_refresh_btn").click();
                                }
                            });
                        } else {
                            Swal.fire({
                                icon: "error",
                                title: "حذف پرداخت",
                                text: 'حذف با خطا مواجه شد',
                                confirmButtonText: "فهمیدم"
                            })
                        }
                    }
                })
            }
        })
    })


})