<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: GET, OPTIONS, POST");

use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use FwRoutingSystem\Router;
use model\PaymentTable;
use site\helpers\ZarinPalPayment;

//ini_set('session.save_path', '/tmp');
ini_set('error_reporting', E_ALL);
ini_set('display_errors', E_ALL);
include '../admin/src/autoload.php';
const __API__ = __DIR__ . '/routes/';
define("__HOST__", "https://api." . str(FwConfig::HOST())->explode('/')[0]);
const __IMAGES__ = 'https://test.nahid-golkar.ir/admin/src/images/';
const __FILES__ = __IMAGES__ . 'Files/';
$Router = new Router();
Db::table('tblApiRequests')->insert([
	'ip'      => getIp(),
	'route'   => $_SERVER['REQUEST_URI'],
	'headers' => json_encode(getallheaders()),
	'body'    => json_encode([
		'input' => file_get_contents('php://input') ?? [],
		'post'  => $_POST,
		'get'   => $_GET,
	]),

]);

$Router->get('/qrcode', function () {
	include 'qrcode.php';
});
header('Content-Type: application/json');
const global_error = "Unknown error!";
http_response_code(500);

function response($content, $statusCode = 200) {
	http_response_code($statusCode);
	return is_iterable($content) ? json_encode($content, JSON_UNESCAPED_UNICODE) : $content;
}

$Router->any('/callback', function () {
	header("Content-Type: text/html");

	$Authority = $_GET['Authority'];
	$Payment = new ZarinPalPayment();
	$Payment->initPayment(new PaymentTable());
	[
		$paymentData,
		$paymentResult
	] = $Payment->getResult($Authority);
	$paymentId = $paymentData->payment_id;
	$amount = $paymentData->payment_amount;
	if (isset($paymentResult) and isset($paymentResult['data']) and isset($paymentResult['data']['code']) and $paymentResult['data']['code'] == 100) {
		$Payment->update($_GET['Authority'], $_GET['Authority']);
		include __BASE_DIR__ . '/callback-success.php';
	} else {
		include __BASE_DIR__ . '/callback-fail.php';
	}
});
$Router->any('/', function () {
	return response([], 404);
});
$Router->any('/main/index', function () {
	return response([], 404);
});

$Router->use(\version\ApiVersions::version(\version\ApiVersions::one, [
	\routes\v1\AuthRoute::class,
	\routes\v1\BotRoute::class,
	\routes\v1\PagesRoute::class,
	\routes\v1\StoryRoute::class,
	\routes\v1\BookRoute::class,
	\routes\v1\AudioBookRoute::class,
]));
$Router->use(\version\ApiVersions::version(\version\ApiVersions::two, [
	\routes\v2\AuthRoute::class,
	\routes\v2\PagesRoute::class,
	\routes\v2\ContentRoute::class,
	\routes\v2\ShopRoute::class,
	\routes\v2\BookRoute::class,
	\routes\v2\ActionsRoute::class,
	\routes\v2\ClubRoute::class,
]));


$Router->error(function () {
	echo response(['message' => 'endpoint not found'], 404);
});
$Router->any(':all/:all?/:all?/:all?/:all?/:all?', function () {
	return response(['message' => 'endpoint not found'], 404);
});
