<?php

namespace routes\v1;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use fwJson\Json;
use FwRoutingSystem\Router;
use model\AudioBookEpisodes;
use model\AudioBooks;
use model\Books;
use model\Discounts;
use model\DiscountUses;
use model\Entity\AudioBooksEntity;
use model\Entity\BookmarksEntity;
use model\Entity\BooksEntity;
use model\Entity\DiscountsEntity;
use model\Entity\MembershipsEntity;
use model\Entity\NotificationsEntity;
use model\Entity\OnboardingsEntity;
use model\Entity\PlansEntity;
use model\Entity\StoriesEntity;
use model\Entity\UserAddressesEntity;
use model\Entity\UsersEntity;
use model\Episodes;
use model\Memberships;
use model\Notifications;
use model\Onboardings;
use model\PaymentTable;
use model\Plans;
use model\Stories;
use model\Transactions;
use model\UserAddresses;
use model\Users;
use payment\BasePayment;
use PHPMailer\PHPMailer\Exception;
use site\helpers\IranPayment;
use site\helpers\ZarinPalPayment;
use version\ApiVersions;

class PagesRoute extends \Api\BaseRouter {
	public string $version = ApiVersions::one;
	public $groupPath = 'pages';

	public function routes(Router $router) {
		$router->get('/on-boarding', function () {
			$pages = Onboardings::getAll()->map(function (OnboardingsEntity $onboardingsEntity) {
				return $onboardingsEntity->apiFormat();
			});
			return response($pages);
		});

		// parsa new index api
		$router->get('/index', function () {
			$user = Users::findToken(get_header('auth'));
			$story = Stories::Db()->where('is_ended', '=', 0)->limit(1)->get()->first;
			if ($story instanceof StoriesEntity) {
				$lastEpisode = Episodes::Db()->where('story_id', $story->story_id)->orderBy('episode_id', true)->limit(1)->get()->first;
				$story = $story->apiFormat($lastEpisode);
			}
			$books = Books::Db()->limit(3)->get()->map(function (BooksEntity $book) {
				return $book->apiFormat();
			});
			$stories = Stories::Db()->orderBy('created_at', true)->limit(3)->get()->map(function (StoriesEntity $story) {
				return $story->apiFormat();
			});
			$audioBooks = AudioBooks::Db()->orderBy("created_at", true)->limit(3)->get()->map(function (AudioBooksEntity $audioBook) {
				return $audioBook->apiFormat();
			});
			return response([
				'story'      => $story,
				'books'      => $books->values(),
				'stories'    => $stories->values(),
				'audioBooks' => $audioBooks->values()
			]);
		});
		$router->post('/search', function () {
			$user = Users::findToken(get_header('auth'));
			$query = $this->getParam('q');
			$books = Books::Db()->where('book_name', 'like', "%$query%")->get()->map(function (BooksEntity $book) {
				return $book->apiFormat();
			});
			$stories = Stories::Db()->where('story_name', 'like', "%$query%")->orderBy('created_at', true)->get()->map(function (StoriesEntity $story) {
				return $story->apiFormat();
			});
			$audioBooks = AudioBooks::Db()->where('audio_book_name', 'like', "%$query%")->orderBy('created_at', true)->get()->map(function (AudioBooksEntity $audioBook) {
				return $audioBook->apiFormat();
			});
			return response([
				'books'      => $books->values(),
				'stories'    => $stories->values(),
				'audioBooks' => $audioBooks->values()
			]);
		});

		// this was meyt:
//        $router->get('/index', $this->middleware($router), function () {
//            $user = Users::findToken(get_header('auth'));
//            $membership_id = $user->membership_id;
//            $todayStories = Episodes::Db()->where('episode_date',"=",strtotime('today'))->get();
//            $todayStoriesOutput =[];
//            foreach ($todayStories as $episode){
//                $plan_id = \model\Stories::get($episode->story_id)->plan_id;
//                if ($plan_id == 0){
//                    /** @var EpisodesEntity $episode */
//                    $todayStoriesOutput[] = $episode->apiFormat();
//                }else{
//                    if ($plan_id >= $membership_id && $membership_id > 0){
//                        /** @var EpisodesEntity $episode */
//                        $todayStoriesOutput[] = $episode->apiFormat();
//                    }
//                }
//            }
//
//            return response([
//                'todayStories' => $todayStoriesOutput,
//            ]);
//        });

		$router->get('/plans', function () {
			return response(Memberships::Db()->get()->map(function (MembershipsEntity $membership) {
				return $membership->apiFormat();
			})->values());
		});

		$router->get('/notifications', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			Users::edit($user->user_id, [
				'last_notif_seen_date' => time(),
			]);
			$notifications = Notifications::Db()->where('user_id', "like", "%\"$user->user_id\"%")->orWhere('user_id', "like", "%all%")->orderBy('created_at', true)->get()->map(function (NotificationsEntity $notification) use ($user) {
				return $notification->apiFormat($user);
			});
			return response($notifications);
		});

		$router->get('/bookmarks', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$bookmarks = \model\Bookmarks::Db()->where('user_id', $user->user_id)->get()->map(function (BookmarksEntity $bookmark) use ($user){
				return $bookmark->apiFormat($user);
			});
			return response([
				'books'   => collect($bookmarks->all())->filter(function ($bookmark) {
					return $bookmark['book'] != null;
				})->map(function ($bookmark) {
					return $bookmark['book'];
				})->values(),
				'stories' => collect($bookmarks->all())->filter(function ($bookmark) {
					return $bookmark['story'] != null;
				})->map(function ($bookmark) {
					return $bookmark['story'];
				})->values(),
				'audioBooks' => collect($bookmarks->all())->filter(function ($bookmark) {
					return $bookmark['bookmark'] != null;
				})->map(function ($bookmark) {
					return $bookmark['bookmark'];
				})->values(),
			]);
		});

		$router->get('/support', function () {
			return response(['link' => 'https://www.goftino.com/c/F7CIVL']);;
		});
		$router->get('/addresses', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$items = UserAddresses::Db()->where('user_id', $user->user_id)->get()->map(function (UserAddressesEntity $wishlistEntity) {
				return $wishlistEntity->apiFormat();
			});
			return response($items->values());
		});
		$router->group('/discounts', function (Router $router) {
			$router->post('/check', $this->middleware($router), function () {
				$user = Users::findToken(get_header('auth'));

				$code = $this->getParam('code');
				$discountCode = \model\Discounts::Db()->where('discount_code', 'like', "$code")->get()->first;
				if ($discountCode instanceof DiscountsEntity) {
					$number = DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->rowCount();
					$use = DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->where('user_id', $user->user_id,)->rowCount();
					if ($number < $discountCode->number and $use < $discountCode->use and $discountCode->expire_date > time()) {
						return response([
							'message'  => 'کد قابل استفاده است',
							'discount' => $discountCode->apiFormat(),
						]);
					} else {
						return response([
							'message' => 'دفعات مجاز استفاده از کد به پایان رسیده'
						], 400);
					}
				} else {
					return response([
						'message' => 'کد تخفیف یافت نشد'
					], 404);
				}
			});
			$router->get('/list', $this->middleware($router), function () {
				$codes = Discounts::getAll();
				return response($codes->map(function (DiscountsEntity $code) {
					return $code->apiFormat();
				}));
			});
		});
		$router->post('/buyPlan/:id', $this->middleware($router), function ($id) {
			$membership = Memberships::get($id);
			$user = Users::findToken(get_header('auth'));
			$code = $this->getParam('code', false);
			$paymentType = $this->getParam('paymentType', false) ?? 2;
//			return response([
//				'message' => "امکان خرید اشتراک میسر نمی باشد"
//			], 404);
			$code = "";
			if ($membership instanceof MembershipsEntity) {

				$price = $membership->price;
//				$discountCode = \model\Discounts::Db()->where('discount_code', 'like', "$code")->get()->first;
//				if ($discountCode instanceof DiscountsEntity) {
//					$number = DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->rowCount();
//					$use = DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->where('user_id', $user->user_id,)->rowCount();
//					if ($number < $discountCode->number and $use < $discountCode->use) {
//						switch ($discountCode->type) {
//							case "1":
//								$price = ($price - intval($price * $discountCode->amount / 100));
//								break;
//							case "2":
//								$price = ($price - intval($discountCode->amount));
//								break;
//						}
//					}
//				}
				switch ($paymentType) {

					case 2:

						$payment = new ZarinPalPayment();
						$payment->initPayment(new PaymentTable());
						$payment->UserModel(new Users(), $user);
						$payment->_amount = $price * 10;
						$payment->Type('buyPlan');
						$payment->OrderData(Json::encode([
							'membershipId'   => $membership->membership_id,
							'userId'         => $user->user_id,
							'discountCode'   => $code,
							'discountAmount' => $membership->price - $price,
						]));
						$result = $payment->goToPayment();
						if (filter_var($result, FILTER_VALIDATE_URL)) {
							return response(['pay' => $result]);
						} else {
							return response(['message' => $result], 400,);
						}
					case 3:
						$image = base64_decode($this->getParam('receipt'));
						$name = time() . '.jpg';
						$res = file_put_contents(__SOURCE__ . 'images/Payment/' . $name, $image);
						if ($res > 0) {
							if (PaymentTable::add([
								'user_id'        => $user->user_id,
								'payment_amount' => $price * 10,
								'payment_resnum' => BasePayment::_createResnum('payment_resnum'),
								'payment_date'   => time(),
								'payment_type'   => 'buyPlan_card',
								'payment_gate'   => 'کارت به کارت',
								'payment_data'   => json_encode([
									'receipt'        => $name,
									'membershipId'   => $membership->membership_id,
									'userId'         => $user->user_id,
									'discountCode'   => $code,
									'discountAmount' => $membership->price - $price,
								]),
								'payment_from'   => "app",
							])) {
								return response([
									'message' => "رسید با موفقیت ذخیره شد، اشتراک شما بعد از بررسی فیش فاریزی فعال خواهد شد."
								]);
							} else {
								unlink(__SOURCE__ . 'images/Payment/' . $name);
								return response([
									'message' => "خطایی در ذخیره سازی رسید رخ داد"
								], 400);
							}
						} else {
							return response([
								'message' => "خطایی در آپلود رسید رخ داد"
							], 404);
						}
						break;
				}

			} else {
				return response([
					'message' => "اشتراک یافت نشد! لطفا یک اشتراک را انتخاب کنید"
				], 404);
			}
		});

		$router->get('/book/:id', function ($id) {
			$book = Books::get($id);
			if ($book instanceof BooksEntity) {
				$user = Users::findToken(get_header('auth'));
				$isBookmarked = false;
				if ($user instanceof UsersEntity) {
					$isBookmarked = \model\Bookmarks::Db()->where('user_id', $user->user_id)->where('book_id', $id)->get()->first instanceof BookmarksEntity;
				}
				return response([
					'book' => $book->apiFormat($isBookmarked),
				]);
			} else {
				return response([
					'message' => "کتاب یافت نشد!",
				], 404);
			}
		});
		$router->get('/episode/:all/:id', $this->middleware($router), function ($type, $id) {
			$user = Users::findToken(get_header('auth'));
			$plan = Memberships::get($user->membership_id);

			$story = null;
			$audioBook = null;
			if ($user instanceof UsersEntity) {

				if ($type == 'story') {
					$episode = Episodes::get($id);
					if (($plan instanceof MembershipsEntity and $user->membership_expired_at > 0 and $user->membership_activated_at > 0 and $user->membership_expired_at <= time()) or $plan == null) {
						return response(['message' => "شما به این داستان دسترسی ندارید!"], 404);
					} else {
						try {

							$story = Stories::get($episode->story_id)->singleApiFormat();
						} catch (Exception $exception) {

						}
					}
				} else {
					$episode = AudioBookEpisodes::get($id);
					if (($plan instanceof MembershipsEntity and !in_array($episode->audio_book_id, json_decode($plan->audio_book_ids, true) ?? [])) or $plan == null) {
						return response(['message' => "شما به این داستان دسترسی ندارید!"], 404);
					} else {
						try {
							$array = [
								'user_id'       => $user->user_id,
								'audio_book_id' => $episode->audio_book_id,
							];
							Db::table('tblAudioBookUse')->where($array)->delete();
							Db::table('tblAudioBookUse')->insert($array);
							$audioBook = AudioBooks::get($episode->audio_book_id)->singleApiFormat();
						} catch (Exception $exception) {

						}
					}
				}
				if ($episode instanceof EntityScheme) {
					return response([
						'episode'   => $episode->apiFormat(),
						'story'     => $story,
						'audioBook' => $audioBook,
						'type'      => $type,
					]);
				}
			} else {
				return response(['message' => "شما به این داستان دسترسی ندارید!"], 403);

			}
			return response(['message' => "این قسمت یافت نشد!"], 404);

		});


		$router->post('/buyPlan/:id', function ($id) {
			$membership = Memberships::get($id);
			$user = Users::findToken(get_header('auth'));


			if ($membership instanceof MembershipsEntity) {

				$price = $membership->price;

				$payment = new ZarinPalPayment();
				$payment->initPayment(new PaymentTable());
				$payment->UserModel(new Users(), $user);
				$payment->_amount = $price * 10;
				$payment->OrderData(Json::encode([
					'membershipId' => $membership->membership_id,
					'userId'       => $user->user_id,
				]));
				return response($payment->goToPayment());

			} else {
				return response([
					'message' => "اشتراک یافت نشد! لطفا یک اشتراک را انتخاب کنید"
				], 404);
			}
		});

	}

	public
	function requiredHeaders(): array {
		return $this->auth();
	}

}
