<?php

namespace routes\v1;

use FwRoutingSystem\Router;
use model\Comments;
use model\Entity\BookmarksEntity;
use model\Entity\MembershipsEntity;
use model\Entity\StoriesEntity;
use model\Entity\UsersEntity;
use model\Entity\WatchlistEntity;
use model\Memberships;
use model\Stories;
use model\Users;
use model\Watchlist;
use version\ApiVersions;

class StoryRoute extends \Api\BaseRouter {
	public string $version = ApiVersions::one;
	public $groupPath = 'story';

	public function routes(Router $router) {
//        $router->get('/todayStories', function () {
//            return response(Episodes::Db()->where('episode_date',"=",strtotime('today'))->get()->map(function (EpisodesEntity $episode) {
//                return $episode->apiFormat();
//            })->values());
//        });
		$router->post('/comment/:id', $this->middleware($router), function ($storyId) {
			$user = Users::findToken(get_header('auth'));
			$rate = $this->getParam('rate');
			$text = $this->getParam('text');
			$story = \model\Stories::get($storyId);
			if ($story instanceof StoriesEntity) {
				if (Comments::add([
					'story_id'     => $story->story_id,
					'comment_rate' => $rate,
					'comment_text' => $text,
					'user_id'      => $user->user_id,
				])) {
					return response([
						'message' => "نظر شما ثبت شد",
					]);
				} else {
					return response([
						'message' => "خطا در ذخیره نظر"
					], 400);
				}
			}
			return response([
				'message' => "داستان پیدا نشد"
			], 404);
		});

		$router->post('/bookmark/:id', $this->middleware($router), function ($storyId) {
			$user = Users::findToken(get_header('auth'));
			$story = \model\Stories::get($storyId);
			if ($story instanceof StoriesEntity) {
				$bookmark = \model\Bookmarks::Db()->where('user_id', $user->user_id)->where('story_id', $storyId)->get()->first;
				if ($bookmark instanceof BookmarksEntity) {
					if (\model\Bookmarks::delete($bookmark->bookmark_id)) {
						return response([
							'message' => "داستان از لیست بوک مارک ها حذف شد"
						]);
					} else {
						return response([
							'خطا در پردازش اطلاعات'
						], 400);
					}
				} else {
					if (\model\Bookmarks::add([
						'user_id'  => $user->user_id,
						'story_id' => $storyId
					])) {
						return response([
							'message' => "داستان به لیست بوک مارک ها اضافه شد"
						]);
					} else {
						return response([
							'خطا در پردازش اطلاعات'
						], 400);
					}
				}
			}
			return response([
				'message' => "داستان پیدا نشد"
			], 404);
		});


		// this is parsa:

		$router->post('/watchlist/:id', $this->middleware($router), function ($id) {
			$user = Users::findToken(get_header('auth'));

			$isListed = Watchlist::Db()->where([
				'story_id' => $id,
				'user_id'  => $user->user_id,
			])->get()->first;
			if ($isListed instanceof WatchlistEntity) {
				return response(['message' => "شما قبلا این داستان را در لیست انتظار خود ثبت کرده بودید!"]);
			} else {
				if (Watchlist::add([
					'story_id' => $id,
					'user_id'  => $user->user_id,
				])) {
					return response(['message' => "داستان با موفقیت به لیست انتظارتان اضافه شد!"]);
				}
			}
			return response(['message' => "خطایی در ثبت داستان در لیست انتظار رخ داد"], 400);
		});

	}

	public function requiredHeaders(): array {
		return $this->auth();
	}

}
