<?php

namespace routes\v2;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use FwRoutingSystem\Router;
use model\AudioBookEpisodes;
use model\AudioBooks;
use model\Banners;
use model\Books;
use model\Discounts;
use model\DiscountUses;
use model\Entity\AudioBooksEntity;
use model\Entity\BannersEntity;
use model\Entity\BookmarksEntity;
use model\Entity\BooksEntity;
use model\Entity\DiscountsEntity;
use model\Entity\EventsEntity;
use model\Entity\MembershipsEntity;
use model\Entity\NewsEntity;
use model\Entity\NotificationsEntity;
use model\Entity\OnboardingsEntity;
use model\Entity\PlansEntity;
use model\Entity\StoriesEntity;
use model\Entity\UserAddressesEntity;
use model\Entity\UsersEntity;
use model\Episodes;
use model\Events;
use model\Memberships;
use model\News;
use model\Notifications;
use model\Onboardings;
use model\PaymentTable;
use model\Stories;
use model\UserAddresses;
use model\Users;
use model\Views;
use PHPMailer\PHPMailer\Exception;
use site\helpers\IranPayment;
use version\ApiVersions;

class PagesRoute extends \Api\BaseRouter {
	public string $version = ApiVersions::two;
	public $groupPath = 'pages';

	public function routes(Router $router) {
		$router->get('/on-boarding', function () {
			$pages = Onboardings::getAll()->map(function (OnboardingsEntity $onboardingsEntity) {
				return $onboardingsEntity->apiFormat();
			});
			return response($pages);
		});

		$router->get('/index', function () {
			$user = Users::findToken(get_header('auth'));
			$story = Stories::Db()->where('is_ended', '=', 0)->limit(1)->get()->first;
			if ($story instanceof StoriesEntity) {
				$lastEpisode = Episodes::Db()->where('story_id', $story->story_id)->orderBy('episode_id', true)->limit(1)->get()->first;
				$story = $story->apiFormat($lastEpisode);
			}
			$books = Books::Db()->limit(3)->get()->map(function (BooksEntity $book) {
				return $book->apiFormat();
			});
			$stories = Stories::Db()->orderBy('created_at', true)->limit(3)->get()->map(function (StoriesEntity $story) {
				return $story->apiFormat();
			});
			$audioBooks = AudioBooks::Db()->orderBy("created_at", true)->limit(3)->get()->map(function (AudioBooksEntity $audioBook) {
				return $audioBook->apiFormat();
			});
			$banners = Banners::getAll()->map(function (BannersEntity $bannersEntity) {
				return __IMAGES__ . 'Banners/' . $bannersEntity->banner_image;
			})->values();
			return response([
				'story'      => $story,
				'books'      => $books->values(),
				'stories'    => $stories->values(),
				'audioBooks' => $audioBooks->values(),
				'banners'    => $banners,
			]);
		});


		$router->get('/plans', function () {
			return response(Memberships::Db()->where('membership_duration', '>=', 30)->get()->map(function (MembershipsEntity $membership) {
				return $membership->apiFormat();
			})->values());
		});

		$router->get('/notifications', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			Users::edit($user->user_id, [
				'last_notif_seen_date' => time(),
			]);
			$notifications = Notifications::Db()->where('user_id', "like", "%\"$user->user_id\"%")->orWhere('user_id', "like", "%all%")->orWhere('user_id', "=", $user->user_id)->orderBy('created_at', true)->get()->map(function (NotificationsEntity $notification) use ($user) {
				return $notification->apiFormat($user);
			});
			return response($notifications);
		});

		$router->get('/bookmarks', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$bookmarks = \model\Bookmarks::Db()->where('user_id', $user->user_id)->get()->map(function (BookmarksEntity $bookmark) use ($user) {
				return $bookmark->apiFormat($user);
			});
			return response($bookmarks->values());
		});

		$router->get('/support', function () {
			return response(['link' => 'https://www.goftino.com/c/F7CIVL']);
		});

		$router->get('/addresses', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$items = UserAddresses::Db()->where('user_id', $user->user_id)->get()->map(function (UserAddressesEntity $wishlistEntity) {
				return $wishlistEntity->apiFormat();
			});
			return response($items->values());
		});
		$router->get('/payments', $this->middleware($router), function () {
			$user = Users::findToken(get_header('auth'));
			$items = PaymentTable::Db()->where('user_id', $user->user_id)->orderBy('payment_date', true)->get()->map(function ($payment) {
				return PaymentTable::toDataModel($payment);
			});
			return response($items->values());
		});
		$router->group('/discounts', function (Router $router) {
			$router->post('/check', $this->middleware($router), function () {
				$user = Users::findToken(get_header('auth'));

				$code = $this->getParam('code');
				$discountCode = \model\Discounts::Db()->where('discount_code', 'like', "$code")->get()->first;
				if ($discountCode instanceof DiscountsEntity) {
					$number = DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->rowCount();
					$use = DiscountUses::Db()->where('discount_id', $discountCode->discount_id)->where('user_id', $user->user_id,)->rowCount();
					if ($number < $discountCode->number and $use < $discountCode->use and $discountCode->expire_date > time()) {
						return response([
							'message'  => 'کد قابل استفاده است',
							'discount' => $discountCode->apiFormat(),
						]);
					} else {
						return response([
							'message' => 'دفعات مجاز استفاده از کد به پایان رسیده'
						], 400);
					}
				} else {
					return response([
						'message' => 'کد تخفیف یافت نشد'
					], 404);
				}
			});
			$router->get('/list', $this->middleware($router), function () {
				$codes = Discounts::getAll();
				return response($codes->map(function (DiscountsEntity $code) {
					return $code->apiFormat();
				}));
			});
		});

		$router->get('/book/:id', function ($id) {
			$book = Books::get($id);
			if ($book instanceof BooksEntity) {
				$user = Users::findToken(get_header('auth'));
				$isBookmarked = false;
				if ($user instanceof UsersEntity) {
					$isBookmarked = \model\Bookmarks::Db()->where('user_id', $user->user_id)->where('book_id', $id)->get()->first instanceof BookmarksEntity;
				}
				return response([
					'book' => $book->apiFormat($isBookmarked),
				]);
			} else {
				return response([
					'message' => "کتاب یافت نشد!",
				], 404);
			}
		});
		$router->get('/episode/:all/:id', $this->middleware($router), function ($type, $id) {
			$user = Users::findToken(get_header('auth'));
			$plan = Memberships::get($user->membership_id);

			$story = null;
			$audioBook = null;
			if ($user instanceof UsersEntity) {

				$artist_id = 0;
				if ($type == 'story') {
					$episode = Episodes::get($id);

					if ($episode->number > 3 and
						(!($plan instanceof MembershipsEntity and $user->membership_expired_at > 0 and $user->membership_activated_at > 0 and $user->membership_expired_at > time()) or $plan == null)) {
						return response([
							'message' => "شما به این داستان دسترسی ندارید!"
						], 404);
					} else {
						try {

							$story = Stories::get($episode->story_id)->singleApiFormat();
							$artist_id = $story['artist']['id'];
							$type = 'story';
						} catch (Exception $exception) {

						}
					}
				} else {
					$episode = AudioBookEpisodes::get($id);
					if ($episode->number > 3 and
						(!($plan instanceof MembershipsEntity and $user->membership_expired_at > 0 and $user->membership_activated_at > 0 and $user->membership_expired_at > time()) or $plan == null)) {
						return response(['message' => "شما به این داستان دسترسی ندارید!"], 404);
					} else {
						try {
							$array = [
								'user_id'       => $user->user_id,
								'audio_book_id' => $episode->audio_book_id,
							];
							Db::table('tblAudioBookUse')->where($array)->delete();
							Db::table('tblAudioBookUse')->insert($array);
							$audioBook = AudioBooks::get($episode->audio_book_id)->singleApiFormat();
							if (is_array($audioBook['artist'] and isset($audioBook['artist']))) {
								$artist_id = $story['artist']['id'];
							}
							$type = 'audio_book';

						} catch (Exception $exception) {

						}
					}
				}
				if ($episode instanceof EntityScheme) {
					Views::add([
						'user_id'       => $user->user_id,
						'artist_id'     => $artist_id,
						'content_type'  => $type,
						'story_id'      => $type == 'story' ? $story['id'] : 0,
						'audio_book_id' => $type == 'audio_book' ? $audioBook['id'] : 0,
						'content_id'    => $episode->id,
					]);
					return response([
						'episode'   => $episode->apiFormat(),
						'story'     => $story,
						'audioBook' => $audioBook,
						'type'      => $type,
					]);
				}
			} else {
				return response(['message' => "شما به این داستان دسترسی ندارید!"], 403);

			}
			return response(['message' => "این قسمت یافت نشد!"], 404);

		});


		$router->get('/news', function () {
			$news = News::Db()->orderBy('created_at', true)->get()->map(function (NewsEntity $newsEntity) {
				return $newsEntity->apiFormat();
			});
			return response($news);
		});

		$router->get('/events', function () {
			$events = Events::Db()->orderBy('created_at', true)->get()->map(function (EventsEntity $eventsEntity) {
				return $eventsEntity->apiFormat();
			});
			return response($events);
		});
	}

	public
	function requiredHeaders(): array {
		return $this->auth();
	}

}
